#!/bin/bash

function info {
	echo "执行该脚本来提交带符号表SO文件"
	echo "[-f]: so文件路径"
	echo "[-i]: 应用程序的appId"
	echo "[-k]: 应用程序的appKey"
}

if [[ $# = 0 ]]; then
	info
	exit 1
fi

symbolsPaths=""
appId=""
appKey=""

# 获取输入参数
while getopts "f:i:k:" opt; do
  case ${opt} in
    f)
      symbolsPaths=${OPTARG}
      ;;
    i)
	    appId=${OPTARG}
	    ;;
	  k)
	    appKey=${OPTARG}
	    ;;
    ?)
      echo "error: 无效参数"
      exit 1
  esac
done

if [[ -z ${symbolsPaths} ]]; then
	echo "error: 必须输入带符号表SO的路径"
	exit 1
fi

if [[ ! -f ${symbolsPaths} ]]; then
  echo "带符号表SO路径有误"
	exit 1
fi

if [[ ${symbolsPaths} != *.so ]]; then
	echo "带符号表SO路径有误，传入的文件必须以.so结尾"
	exit 1
fi

if [[ -z ${appId} ]]; then
	echo "error: 必须输入应用的appId"
	exit 1
fi

if [[ -z ${appKey} ]]; then
	echo "error: 必须输入应用的appKey"
	exit 1
fi

soFileName=${symbolsPaths##*/}

appVersion="lib_upload_auto"

isMacOs=0
if command -v md5 >/dev/null 2>&1; then
  echo 'Mac环境'
  isMacOs=1
else
    echo "Linux环境"
fi

# 当前目录
cur_dir=`dirname $0`

buildDir="${cur_dir}/rifle_build/"
soParent="${buildDir}app/symbols/${soFileName}/"
mkdir -p ${soParent}
cp ${symbolsPaths} ${soParent}

cd ${buildDir}
zipFile="./${soFileName}.zip"
if [[ -f ${zipFile} ]]; then
  rm ${zipFile}
fi
zip -r "./${soFileName}.zip" "./app/"

if [[ ! -f ${zipFile} ]]; then
  echo "压缩带符号表文件失败"
	exit 1
fi

beforeMD5=${appId}${appVersion}${appKey}
if [[ ${isMacOs} =~ 1 ]]; then

    signKey=`md5 -s $beforeMD5`
    signKey=${signKey// / }
    for element in $signKey
    do
        signKey=$element
    done

else

    signKey=$(echo -n ${beforeMD5}|md5sum|cut -d ' ' -f1)

fi

result=`curl -F "requestDataSecret={\"appVersion\":\"$appVersion\",\"appid\":\"$appId\",\"crashType\":2,\"signKey\":\"$signKey\",\"platform\":1}" -F "file=@${zipFile}" https://cosmos-compass-api.immomo.com/uploadSymbol`

if [[ $result =~ "10000" ]]
then
    echo "提交带符号表SO成功"
else
    echo "提交带符号表SO失败，信息：${result}"
		exit 1
fi

# 删除临时文件
rm ${zipFile}
cd ..
rm -rf ${buildDir}